/*****************************************************************************
*  LPC15xx SCT demo
*
*  Use SCT2 as unified timer to generate an interrupt every 10 msec
*  LPC15xx - SCT0/1 support: – 8 inputs
*                            – 10 outputs
*                            – 16 match/capture registers
*                            – 16 events
*                            – 16 states
*            SCT2/3 support: – 3 inputs
*                            – 6 outputs
*                            – 8 match/capture registers
*                            – 10 events
*                            – 10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT1_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT1;                // enable the SCT0 clock

    LPC_SCT1->CONFIG           |= (1   << 0)  |            // unified timer
                                  (0x3 << 1)  |            // SCT clock is input selected by CLKSEL
                                  (0xF << 3)  |            // falling edge of input 7 (SCT PLL)
                                  (1   << 17);             // auto limit

    LPC_SCT1->MATCH[0].U        = (72000000/10) -1;        // match 0 @ 10 Hz = 100 msec
    LPC_SCT1->MATCHREL[0].U     = (72000000/10) -1;

    LPC_SCT1->EVENT[0].STATE    = 0xFFFFFFFF;              // event 0 happens in all states
    LPC_SCT1->EVENT[0].CTRL     = (1 << 12);               // match 0 condition only

    LPC_SCT1->OUT[0].SET        = (1 << 0);                // event 0 will set SCT0_OUT0
    LPC_SCT1->OUT[0].CLR        = (1 << 0);                // event 0 will clear SCT0_OUT0
    LPC_SCT1->RES               = (3 << 0);                // output 0 toggles on conflict

    LPC_SCT1->CTRL_U           &= ~(1 << 2);               // start timer
}
